// Delete Edge.js
//
// this is a Macro script for Cheetah3D. place this into ~/Library/Applciation Support/Cheetah3D/scripts/Macro folder

// v.20081216: first version
// v.20081216b: fixed multiple delete bug.
// v.20081217: optimize
// v.20081227: fix bug
// v.20090103: fix bug

// Array extension
Array.prototype.edge_detect = false;
Array.prototype.pushUniqueEdge = function(val) {
	var len = this.length;
	var res = true;
	for (var i = 0;i < len;i++) {
		if (this[i].equalTo(val)) {
			this[i].p2 = val.p1;
			this.edge_detect = true;
			res = false;
		}
	}
	if (res && val != null) {
		this[len] = val;
		return this.length;
	} else {
		return false;
	}
}
Array.prototype.pushUnique = function(val) {
	var len = this.length;
	var res = true;
	for (var i = 0;i < len;i++) {
		if (this[i] == val) {
			return false;
		}
	}
	this[len] = val;
	return this.length;
}
// Edge Class
function Edge(v1, v2) {
	this.v1 = v1;
	this.v2 = v2;
	this.p1 = null;
	this.p2 = null;
}
Edge.prototype.toString = function () {
	return 'edge:'+this.v1+','+this.v2+' p:'+this.p1+','+this.p2;
}
Edge.prototype.equalTo = function (edge) {
	return (this.v1 == edge.v1 && this.v2 == edge.v2) || (this.v1 == edge.v2 && this.v2 == edge.v1);
}

function detectEdgeSelection(core) {
	var polyCount = core.polygonCount();
	var cache = new Array;
	for (var i = 0;i < polyCount;i++) {
		var polySize = core.polygonSize(i);
		
		for (var j = 0;j < polySize;j++) {
			if (core.edgeSelection(i, j, SELECT)) {
				var vn = (j == polySize - 1)? 0 : j+1;
				var v1 = core.vertexIndex(i, j);
				var v2 = core.vertexIndex(i, vn);
				var edge = new Edge(v1, v2);
				edge.p1 = i;
				cache.pushUniqueEdge(edge);
			}
		}
	}
	var len = cache.length;
	var list = new Array;
	for (i = 0;i < len;i++) {
		if (cache[i].p1 != null && cache[i].p2 != null) {
			list.push(cache[i]);
		}
	}
	return list;
}
//
function main(doc) {
	var obj = doc.selectedObject();
	
	if (! obj || obj.family() != NGONFAMILY) {
		return;
	}
	
	//print("---- Delete Edge.js ----");
	var core = obj.core();
	var cache = detectEdgeSelection(core);
	var del_cache = [];
	
	// bench
	var poly_count = 0;
	var st1 = new Date().getTime();
	
	while (cache.length > 0) {
		// getting first edge of selection : 選択されたエッジの１番目を取得
		var edge = cache[0];
		var cache_len = cache.length;
		var i,j,k;
		
		if (edge.p1 != null && edge.p2 != null) {
			var list = new Array;
			var uvs = new Array;
			var uvs_info = new Array;
			var res = false;
			
			// getting vertices of polygons makes target edge : エッジ構成ポリゴンの頂点データを取得
			var s1_len = core.polygonSize(edge.p1);
			var s1_cache = [];
			for (j = 0;j < s1_len;j++) {
				var vi = core.vertexIndex(edge.p1, j);
				s1_cache.push(vi);
				uvs_info.push([vi, core.uvCoord(edge.p1, j)]);
			}
			var s2_len = core.polygonSize(edge.p2);
			var s2_cache = [];
			var s2_cache_s = [];
			var s2_j = 0;
			var s2_start = false;
			while (s2_cache.length < s2_len-2) {
				var vi = core.vertexIndex(edge.p2, s2_j);
				if (s2_start) {
					s2_cache.push(vi);
					uvs_info.push([vi, core.uvCoord(edge.p2, s2_j)]);
				}
				if (vi == edge.v1) {
					s2_start = true;
				} else if (vi == edge.v2) {
					s2_start = false;
				}
				s2_j = (s2_j == s2_len - 1)? 0 : s2_j+1;
			}
			for (j = 0;j < s2_len;j++) {
				var vi = core.vertexIndex(edge.p2, j);
				s2_cache_s.push(vi);
			}
			
			/*
			print('v1:'+edge.v1+', v2:'+edge.v2);
			print('s1:'+s1_cache);
			print('s2:'+s2_cache);
			print('s2s:'+s2_cache_s);
			*/
			
			for (j = 0;j < s1_len;j++) {
				vi = s1_cache[j];
				if (vi == edge.v1) {
					list.push(vi);
					for (k = 0;k < s2_len-2;k++) {
						list.push(s2_cache[k]);
					}
					j++;
					list.push(s1_cache[j]);
				} else {
					list.push(vi);
				}
			}
			
			
			// isolated point check : 孤立点のチェック
			var vert_count = core.vertexCount();
			var vert_list = [];
			for (i = 0;i < vert_count;i++) {
				vert_list[i] = [];
			}
			var poly_len = core.polygonCount();
			for (i = 0;i < poly_len;i++) {
				var polySize = core.polygonSize(i);
				for (var j = 0;j < polySize;j++) {
					var vert_index = core.vertexIndex(i,j);
					if (i != edge.p1 && i != edge.p2) vert_list[vert_index].push(i);
				}
			}
			var res_list = [];
			var list_len = list.length;
			for (i = 0;i < list.length;i++) {
				var vert_index = list[i];
				//print(vert_list[vert_index]);
				if (vert_list[vert_index] != undefined && vert_list[vert_index].length != 0) {
					res_list.push(vert_index);
				} else {
					;
				}
			}
			//
			
			var list_len = res_list.length;
			for (j = 0;j < list_len;j++) {
				var v_index = res_list[j];
				var uvs_length = uvs_info.length;
				for (var k = 0;k < uvs_length;k++) {
					var uv_info = uvs_info[k];
					if (uv_info[0] == v_index) {
						uvs.push(uv_info[1]);
					}
				}
			}
			
			var pi = core.addIndexPolygon(res_list.length, res_list);
			poly_count++;
			
			// reselect edge for new polygon : 再選択
			for (j = 0;j < cache_len;j++) {
				var edge_sel = cache[j];
				for (k = 0;k < list_len;k++) {
					k_n = (k+1 == list_len)? 0 : k+1;
					if (edge_sel.v1 == res_list[k] && edge_sel.v2 == res_list[k_n]) {
						core.setEdgeSelection(pi, k, SELECT, true);
						//print('resel next');
					}
					if (edge_sel.v2 == res_list[k] && edge_sel.v1 == res_list[k_n]) {
						core.setEdgeSelection(pi, k, SELECT, true);
						//print('resel back');
					}
				}
			}
			// setting UVCoord : UV セット
			for (j = 0;j < list_len;j++) {
				core.setUVCoord(pi, j, uvs[j]);
			}
			
			// delete polygon : ポリゴンを削除
			core.deletePolygon(edge.p1);
			core.deletePolygon(edge.p2);
			
			// update : 頂点番号の更新？用にオブジェクトをアップデート
			obj.update();
		}
		
		// update selection cache : 選択キャッシュを更新
		cache = detectEdgeSelection(core);
	}
	
	obj.update();
	
	// bench
	var st2 = new Date().getTime();
	var st3 = st2 - st1;
	//print("bench:"+st3+", count:"+poly_count);
}